<?php

namespace App\Models;

use App\Traits\HasTranslatedName;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class City extends Model
{
    use HasFactory, SoftDeletes, HasTranslatedName;

    protected $table = 'state5_cities';

    public $timestamps = false;

    protected $fillable = [
        'district_id',
        'county_id',
        'name',
        'name_en',
        'code',
        'slug',
        'global_slug',
        'is_capital',
        'area',
        'population',
        'elevation',
        'postal_code',
        'phone_code',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_capital' => 'boolean',
        'area' => 'decimal:2',
        'population' => 'integer',
        'elevation' => 'integer',
        'deleted_at' => 'datetime',
    ];

    // Relationships
    public function county()
    {
        return $this->belongsTo(County::class);
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function zones()
    {
        return $this->hasMany(Zone::class);
    }

    public function villages()
    {
        return $this->hasMany(Village::class);
    }

    public function locations()
    {
        return $this->hasMany(Location::class);
    }

    // Make name_fa attribute for compatibility
    public function getNameFaAttribute()
    {
        return $this->name;
    }
}
