<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class DatabaseController extends Controller
{
    /**
     * نمایش صفحه ابزارهای دیتابیس
     */
    public function index()
    {
        return view('admin.tools.database');
    }

    /**
     * بهینه‌سازی جداول دیتابیس
     */
    public function optimize()
    {
        try {
            $tables = Schema::getConnection()->getDoctrineSchemaManager()->listTableNames();
            $optimized = [];

            foreach ($tables as $table) {
                DB::statement("OPTIMIZE TABLE `{$table}`");
                $optimized[] = $table;
            }

            return redirect()->back()->with('success', 'بهینه‌سازی جداول با موفقیت انجام شد.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'خطا در بهینه‌سازی جداول: ' . $e->getMessage());
        }
    }

    /**
     * تعمیر جداول دیتابیس
     */
    public function repair()
    {
        try {
            $tables = Schema::getConnection()->getDoctrineSchemaManager()->listTableNames();
            $repaired = [];

            foreach ($tables as $table) {
                DB::statement("REPAIR TABLE `{$table}`");
                $repaired[] = $table;
            }

            return redirect()->back()->with('success', 'تعمیر جداول با موفقیت انجام شد.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'خطا در تعمیر جداول: ' . $e->getMessage());
        }
    }

    /**
     * تحلیل جداول دیتابیس
     */
    public function analyze()
    {
        try {
            $tables = Schema::getConnection()->getDoctrineSchemaManager()->listTableNames();
            $analyzed = [];

            foreach ($tables as $table) {
                DB::statement("ANALYZE TABLE `{$table}`");
                $analyzed[] = $table;
            }

            return redirect()->back()->with('success', 'تحلیل جداول با موفقیت انجام شد.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'خطا در تحلیل جداول: ' . $e->getMessage());
        }
    }

    /**
     * پاکسازی کش سیستم
     */
    public function clearCache()
    {
        try {
            \Artisan::call('cache:clear');
            \Artisan::call('config:clear');
            \Artisan::call('view:clear');
            \Artisan::call('route:clear');

            return redirect()->back()->with('success', 'کش سیستم با موفقیت پاکسازی شد.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'خطا در پاکسازی کش: ' . $e->getMessage());
        }
    }

    /**
     * نمایش صفحه جستجوی پیشرفته دیتابیس
     */
    public function advancedSearch()
    {
        try {
            $tables = Schema::getConnection()->getDoctrineSchemaManager()->listTableNames();
            $tableInfo = [];

            foreach ($tables as $table) {
                $columns = Schema::getColumnListing($table);
                $tableInfo[$table] = $columns;
            }

            return view('admin.tools.advanced-search', compact('tableInfo'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'خطا در دریافت اطلاعات جداول: ' . $e->getMessage());
        }
    }
} 